package com.bytesbee.mysinglelivechannel.activities;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.utils.Utils;
import com.gyf.immersionbar.ImmersionBar;
import com.kongzue.dialogx.dialogs.WaitDialog;


/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */

@SuppressLint("Registered")
public class BaseAppActivity extends AppCompatActivity {

    public Activity mActivity;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mActivity = this;
    }

    public void setImmersionBar() {
        ImmersionBar.with(this)
                .autoDarkModeEnable(true)
                .autoNavigationBarDarkModeEnable(true)
                .applySystemFits(true)
                .transparentBar()
                .init();
    }

    public void setImmersionBarTheme() {
        ImmersionBar.with(this)
                .applySystemFits(true)
                .statusBarColor(R.color.purple_500)
                .init();
    }

    public void showWaitDialog() {
        try {
            WaitDialog.setMessage(R.string.please_wait)
                    .setMaskColor(ContextCompat.getColor(this, com.kongzue.dialogx.R.color.black30))
                    .setAnimResId(com.kongzue.dialogx.R.anim.anim_dialogx_default_alpha_enter, com.kongzue.dialogx.R.anim.anim_dialogx_default_exit)
                    .show();
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    public void hideWaitDialog() {
        try {
            WaitDialog.dismiss();
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
